#include "historical_report.h"

#include <drive/backend/chat_robots/abstract.h>

TChatStatesHistoricalReport::TFactory::TRegistrator<TChatStatesHistoricalReport> TChatStatesHistoricalReport::Registrator(GetTypeName());

TExpectedState TChatStatesHistoricalReport::DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const TExecutionContext& context) const {
    const NDrive::IServer* server = &context.GetServerAs<NDrive::IServer>();
    auto chatRobot = server->GetChatRobot(ChatId);
    if (!chatRobot) {
        ERROR_LOG << GetRobotId() << ": Chat robot monitoring failed: no such chat " << ChatId << Endl;
        return MakeUnexpected<TString>({});
    }
    TMap<TString, size_t> historyByNodes;
    if (!chatRobot->GetHistoryStatsByNodes(WindowSize, historyByNodes)) {
        ERROR_LOG << GetRobotId() << ": Chat robot monitoring failed: could not get history stats by nodes" << Endl;
        return MakeUnexpected<TString>({});
    }
    for (auto&& itemName : chatRobot->GetChatConfig().GetChatScript().GetNodeNames()) {
        historyByNodes.emplace(itemName, 0);
    }
    for (auto&& it : historyByNodes) {
        TUnistatSignalsCache::SignalLastX(GetRTProcessName(), it.first, it.second);
    }
    return new IRTBackgroundProcessState();
}

NDrive::TScheme TChatStatesHistoricalReport::DoGetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = TBase::DoGetScheme(server);
    scheme.Add<TFSString>("chat_id", "id чата").SetRequired(true);
    scheme.Add<TFSDuration>("window_size", "Размер временного окна");
    return scheme;
}

NJson::TJsonValue TChatStatesHistoricalReport::DoSerializeToJson() const {
    NJson::TJsonValue result = TBase::DoSerializeToJson();
    result["chat_id"] = ChatId;
    JWRITE_DURATION(result, "window_size", WindowSize);
    return result;
}

bool TChatStatesHistoricalReport::DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) {
    if (!TBase::DoDeserializeFromJson(jsonInfo)) {
        return false;
    }
    JREAD_STRING(jsonInfo, "chat_id", ChatId);
    JREAD_DURATION(jsonInfo, "window_size", WindowSize);
    return true;
}
