#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/documents_verification/manager.h>
#include <drive/backend/registrar/ifaces.h>

#include <drive/library/cpp/scheme/scheme.h>

class TChatStatesHistoricalReport: public IRTRegularBackgroundProcess {
    TDuration WindowSize;
    TString ChatId;

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TChatStatesHistoricalReport> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "chat_states_historical_report";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
