#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/documents_verification/manager.h>
#include <drive/backend/registrar/ifaces.h>

#include <drive/library/cpp/scheme/scheme.h>

class TChatUnreadPushes: public IRTRegularBackgroundProcess {
    ui32 NightStart = 21 * 60 * 60;
    ui32 NightEnd = 5 * 60 * 60;
    TString PushTagName = "chatnotification_push";
    TDuration WaitPeriod = TDuration::Seconds(12 * 60 + 34);
    TDuration CheckMessagesFrom = TDuration::Days(1);
    TObjectSharding ShardingPolicy;

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TChatUnreadPushes> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "chat_unread_pushes";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
