#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/chat_robots/abstract.h>
#include <drive/backend/data/user_tags.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/proto/background.pb.h>
#include <drive/backend/support_center/request_filter.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <mapreduce/yt/interface/client.h>

class TYtDumpingSettings {
    R_FIELD(TDuration, WindowSize, TDuration::Days(2));
    R_FIELD(size_t, ChunksLimit, 1024);
    R_FIELD(TString, YtCluster, "hahn");
    R_FIELD(TString, TablesPath, "//home/carsharing/production/support/active_chat_monitoring");

public:
    bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo);
    NJson::TJsonValue SerializeToJson() const;
    static NDrive::TScheme GetScheme();
};

class TActiveChatsMonitoring: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TActiveChatsMonitoring> Registrator;

public:
    enum class EAggregationPolicy: ui32 {
        Count = 0 /* "count" */,
        Quantiles = 1 /* "quantile" */,
        Mean = 2 /* "mean" */,
        Buckets = 3 /* "buckets" */,
    };

    enum class EMonitoringAgent: ui32 {
        YT = 0 /* "yt" */,
        Yasm = 1 /* "yasm" */,
        Telegram = 2 /* "telegram" */,
    };

public:
    using TBase::TBase;

    TActiveChatsMonitoring()
        : TBase()
    {
        YtClient = NYT::CreateClient(YtSettings.GetYtCluster(), NYT::TCreateClientOptions());
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "active_chats_monitoring";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;

private:
    mutable TChatSupportRequestsFilter ChatsFilter;
    EAggregationPolicy AggregationPolicy;
    TVector<ui32> Quantiles;
    TString NotifierName;
    TDuration NotificationsDelay = TDuration::Minutes(15);
    EMonitoringAgent MonitoringAgent = EMonitoringAgent::YT;
    TYtDumpingSettings YtSettings;

    NYT::IClientPtr YtClient;
    mutable TVector<NYT::TNode> ReadyNodes;

    void FlushYTMonitoringData() const;
    void StoreSignal(const TString& metricName, const ui32 metricValue) const;
    bool GetChats(const NDrive::IServer* server, TVector<TTaggedUser> taggedUsers, TVector<std::pair<const TSupportChatTag*, ui32>>& monitoringData) const;
    bool MaybeAddMonitoringData(const NDrive::IServer* server, const TDBTag& tag, TVector<std::pair<const TSupportChatTag*, ui32>>& monitoringData) const;
    void PushToAggregatedSensors(const TString& group, TVector<ui32>& values) const;
};

class TRTActiveChatsMonitoringState : public IProtoStateSerializable<NDrive::NProto::TActiveChatMonitoringState> {
private:
    using TBase = IProtoStateSerializable<NDrive::NProto::TActiveChatMonitoringState>;
    static TFactory::TRegistrator<TRTActiveChatsMonitoringState> Registrator;

    TMap<TString, TInstant> LastNotification;

protected:
    virtual void SerializeToProto(NDrive::NProto::TActiveChatMonitoringState& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TActiveChatMonitoringState& proto) override;

public:
    using TBase::TBase;

    virtual NJson::TJsonValue GetReport() const override;
    virtual NDrive::TScheme DoGetScheme() const override;
    TString GetType() const override;

    TInstant GetLastNotifyInstant(const TString& tagId) const;
    void SetLastNotifyInstant(const TString& tagId, const TInstant instant);
};
