#pragma once

#include <drive/backend/rt_background/car_counter/config.h>

#include <drive/backend/background/manager/regular.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>

class TRTCleaningWatcher: public IRTCarsProcess {
private:
    class TCarMatching;
    using TBase = IRTCarsProcess;
    using TStopEvents = TMap<TString, TCarTagHistoryEvent>;

private:
    R_READONLY(bool, RemoveTag, false);
    R_READONLY(bool, IsCriteriaCondition, false);
    R_READONLY(bool, PerformingModification, false);
    R_READONLY(TString, NotifierName);
    R_READONLY(TSet<TString>, TagsForCheck);
    R_READONLY(TString, TagName, "cleaning");
    R_READONLY(i32, TagPriority, 0);
    R_READONLY(TTagsFilter, OfferAttributesFilter);
    R_READONLY(TString, HRReportTemplate);
    R_OPTIONAL(TDuration, CriticalPeriod);
    R_OPTIONAL(TDuration, CriticalRidesDuration);
    R_OPTIONAL(TDuration, CriticalSessionsDuration);
    R_OPTIONAL(ui32, CriticalRidesCount);
    R_OPTIONAL(double, CriticalMileage);
    R_READONLY(bool, DryRunMode, false);
    R_READONLY(bool, EmptyReport, false);

private:
    static TFactory::TRegistrator<TRTCleaningWatcher> Registrator;

private:
    TMaybe<TStopEvents> GetStopEvents(const TSet<TString>& carIds, const IEntityTagsManager& tagManager, NDrive::TEntitySession& session) const;
    bool Match(const TCarMatching& info) const;

protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "cleaning_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

public:
    static TString BaseReport;
};
