#pragma once

#include "state.h"

#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/abstract/frontend.h>

class IBaseSequentialTableImpl;

class TDBTableScanner : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    using TBase::TBase;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

protected:
    const IBaseSequentialTableImpl* GetTable() const;

private:
    virtual bool ProcessRecords(const TRecordsSet& records, const NDrive::IServer& server, ui64& lastEventId, TMessagesCollector& errors) const = 0;
    virtual TRTHistoryWatcherState* BuildState() const = 0;

private:
    R_FIELD(TString, TableName);
    R_FIELD(NDrive::TEventId, StartFromId, 0);
    R_FIELD(TString, Condition);
    R_FIELD(ui32, Quantum, 0);
    R_FIELD(TDuration, LockTimeout, TDuration::Seconds(1));
};
