#pragma once

#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/database/history/common.h>
#include <drive/backend/proto/background.pb.h>

class TRTHistoryWatcherState : public IProtoStateSerializable<NDrive::NProto::THistoryProcessorData> {
private:
    using TBase = IProtoStateSerializable<NDrive::NProto::THistoryProcessorData>;

public:
    R_FIELD(NDrive::TEventId, LastEventId, NDrive::IncorrectEventId);
    R_FIELD(TString, LastError);

protected:
    virtual void SerializeToProto(NDrive::NProto::THistoryProcessorData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::THistoryProcessorData& proto) override;

public:
    using TBase::TBase;

    virtual NJson::TJsonValue GetReport() const override;
    virtual NDrive::TScheme DoGetScheme() const override;
};

class TRTInstantWatcherState : public IProtoStateSerializable<NDrive::NProto::TInstantProcessorData> {
private:
    using TBase = IProtoStateSerializable<NDrive::NProto::TInstantProcessorData>;
    R_FIELD(TInstant, LastInstant, TInstant::Zero());

protected:
    virtual void SerializeToProto(NDrive::NProto::TInstantProcessorData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TInstantProcessorData& proto) override;

public:
    using TBase::TBase;

    virtual NJson::TJsonValue GetReport() const override;
    virtual NDrive::TScheme DoGetScheme() const override;
};

