#pragma once

#include <drive/library/cpp/scheme/scheme.h>

#include <mapreduce/yt/interface/common.h>

class TYtProcessTraits {
protected:
    using TSchema = TMap<TString, NYT::EValueType>;

protected:
    TYtProcessTraits() = default;

    NYT::TTableSchema GetYtSchema(const TSchema& schema) const;
    NYT::TTableSchema GetYtSchema() const;
    bool HasYtSchema() const;

    NYT::TNode Schematize(NYT::TNode&& record, const NYT::TTableSchema& schema) const;
    NYT::TNode Schematize(NYT::TNode&& record) const;

    void FillScheme(NDrive::TScheme& scheme) const;
    void Serialize(NJson::TJsonValue& value) const;
    bool Deserialize(const NJson::TJsonValue& value);

private:
    TMap<TString, NYT::EValueType> Schema;

    NYT::TTableSchema YtSchema;
};
