#pragma once

#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/alerts/condition.h>
#include <drive/backend/alerts/actions/base.h>

#include <rtline/util/types/accessor.h>

namespace NAlerts {
    class TAlertContainer;
}

class TRTCommonAlertsState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTCommonAlertsState> Registrator;
protected:
    virtual TString GetType() const;
};

class TRTCommonAlertsProcess: public IRTRegularBackgroundProcess {
    R_READONLY(NAlerts::EAlertEntityType, EntityType, NAlerts::EAlertEntityType::User);
private:
    THolder<NAlerts::TAlertContainer> AlertImpl;

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTCommonAlertsProcess> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "common_alerts";
    }

    const NAlerts::TAlertContainer& GetAlert() const {
        CHECK_WITH_LOG(AlertImpl);
        return *AlertImpl;
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};

class TRTUniversalRobotState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTUniversalRobotState> Registrator;
protected:
    virtual TString GetType() const;
};
