#pragma once

#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/rt_background/manager/state.h>

class TDocumentPhotosDownload: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

private:
    static TFactory::TRegistrator<TDocumentPhotosDownload> Registrator;

private:
    TString YtCluster = "hahn";
    TString InputPhotoIdsTablePath;
    TString OutputPhotoBytesTablePath;
    ui32 BatchSize = 100;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "document_photos_download";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
