#include "state.h"

#include "processor.h"

TRTDocumentPhotosDownloadState::TFactory::TRegistrator<TRTDocumentPhotosDownloadState> TRTDocumentPhotosDownloadState::Registrator(TDocumentPhotosDownload::GetTypeName());

void TRTDocumentPhotosDownloadState::SerializeToProto(NDrive::NProto::TDocumentPhotosDownloadState& proto) const {
    proto.SetProcessedRows(ProcessedRows);
}

bool TRTDocumentPhotosDownloadState::DeserializeFromProto(const NDrive::NProto::TDocumentPhotosDownloadState& proto) {
    if (proto.HasProcessedRows()) {
        ProcessedRows = proto.GetProcessedRows();
    }
    return true;
}

NJson::TJsonValue TRTDocumentPhotosDownloadState::GetReport() const {
    NJson::TJsonValue result = TBase::GetReport();
    result["processed_rows"] = ProcessedRows;
    return result;
}

NDrive::TScheme TRTDocumentPhotosDownloadState::DoGetScheme() const {
    NDrive::TScheme result = TBase::DoGetScheme();
    result.Add<TFSNumeric>("processed_rows", "Количество обработанных строк");
    return result;
}

TString TRTDocumentPhotosDownloadState::GetType() const {
    return TDocumentPhotosDownload::GetTypeName();
}
