#pragma once

#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/proto/background.pb.h>

class TRTDocumentPhotosDownloadState: public IProtoStateSerializable<NDrive::NProto::TDocumentPhotosDownloadState> {
private:
    using TBase = IProtoStateSerializable<NDrive::NProto::TDocumentPhotosDownloadState>;
    static TFactory::TRegistrator<TRTDocumentPhotosDownloadState> Registrator;
    R_FIELD(ui64, ProcessedRows, 0);

protected:
    virtual void SerializeToProto(NDrive::NProto::TDocumentPhotosDownloadState& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TDocumentPhotosDownloadState& proto) override;

public:
    using TBase::TBase;
    virtual NJson::TJsonValue GetReport() const override;
    virtual NDrive::TScheme DoGetScheme() const override;
    TString GetType() const override;
};
