#pragma once
#include <drive/backend/rt_background/manager/manager.h>
#include <drive/backend/rt_background/car_counter/config.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/tags/tags_manager.h>

#include <rtline/util/types/accessor.h>

class IRTPerformerDropper {
protected:
    virtual TSet<TString> GetFilteredObjects(const IRTBackgroundProcess::TExecutionContext& /* context */) const {
        return {};
    }
    virtual TVector<TString> GetPerformers(const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    virtual TVector<TDBTag> GetTagsToDropPerformer(const IRTBackgroundProcess::TExecutionContext& context, NDrive::TEntitySession& session) const;

    virtual bool FilterTagsByActivity(TVector<TDBTag>& tags, const NDrive::IServer* server, NDrive::TEntitySession& session) const;

    virtual TMaybe<TVector<TDBTag>> DropPerformers(const TString& robotUserId, const IRTBackgroundProcess::TExecutionContext& context, NDrive::TEntitySession& session) const;

    virtual NDrive::INotifier::TPtr GetNotifier(const NDrive::IServer& server) const;
    virtual const IEntityTagsManager& GetObjectsTagsManager(const NDrive::IServer* server) const final;
    virtual NEntityTagsManager::EEntityType GetObjectEntityType() const = 0;

    NDrive::TScheme PatchScheme(NDrive::TScheme& scheme, const IServerBase& server) const;
    bool Parse(const NJson::TJsonValue& jsonInfo);
    NJson::TJsonValue PatchJson(NJson::TJsonValue& result) const;

private:
    R_FIELD(TVector<TString>, PerformerTagNames);
    R_FIELD(TVector<TString>, TagNames);
    R_OPTIONAL(TDuration, ActivityPeriod);
    R_OPTIONAL(TString, NotifierName);
};

class TRTDropCarTagPerformer: public IRTCarsProcess, public IRTPerformerDropper {
private:
    using TBase = IRTCarsProcess;
    using TDropper = IRTPerformerDropper;

private:
    static TFactory::TRegistrator<TRTDropCarTagPerformer> Registrator;

public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "drop_car_tag_performer";
    }

    virtual NEntityTagsManager::EEntityType GetObjectEntityType() const override {
        return NEntityTagsManager::EEntityType::Car;
    }

    virtual TSet<TString> GetFilteredObjects(const IRTBackgroundProcess::TExecutionContext& context) const override {
        const auto modificationContext = dynamic_cast<const TTagsModificationContext*>(&context);
        if (modificationContext) {
            return modificationContext->GetFilteredCarIds();
        }
        ERROR_LOG << "Failed to cast context" << Endl;
        return {};
    }

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};

class TRTDropUserTagPerformer: public IRTRegularBackgroundProcess, public IRTPerformerDropper {
private:
    using TBase = IRTRegularBackgroundProcess;
    using TDropper = IRTPerformerDropper;

private:
    static TFactory::TRegistrator<TRTDropUserTagPerformer> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> /* stateExt */, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "drop_user_tag_performer";
    }

    virtual NEntityTagsManager::EEntityType GetObjectEntityType() const override {
        return NEntityTagsManager::EEntityType::User;
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
