#pragma once
#include <drive/backend/rt_background/car_counter/config.h>

#include <rtline/util/types/accessor.h>

class TRTDropPerformerWatcherConfig: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_FIELD(TVector<TString>, TagNames);
    R_FIELD(TDuration, Duration, TDuration::Hours(12));
    R_FIELD(TString, NotifierName);
private:
    static TFactory::TRegistrator<TRTDropPerformerWatcherConfig> Registrator;
public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "drop_performer";
    }

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
