#pragma once
#include <drive/backend/rt_background/common/config.h>

#include <drive/backend/background/manager/regular.h>

#include <mapreduce/yt/interface/client.h>

#include <rtline/util/types/accessor.h>

class TUsingExternalPromoWatcher : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

private:
    R_READONLY(TString, YtCluster, "hahn");
    R_READONLY(TString, YtPath);
    R_READONLY(TString, PromoKey, "promocode");
    R_READONLY(TString, TagName);
    R_READONLY(TString, NotifierName);

protected:
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "using_external_promo";
    }

private:
    static TFactory::TRegistrator<TUsingExternalPromoWatcher> Registrator;
    NYT::IClientPtr YtClient;
};
