#pragma once

#include "attachment_processor_base.h"

#include <drive/library/cpp/autocode/entities.h>

class TRTAutocodeFinePhotoCollectorState : public IFineAttachmentCollectorState {
public:
    static TString GetTypeName();

    virtual TString GetType() const override {
        return GetTypeName();
    }

private:
    static TFactory::TRegistrator<TRTAutocodeFinePhotoCollectorState> Registrator;
};

class TAutocodeFinePhotoCollectorContext : public IFineAttachmentCollectorContext {
    using TBase = IFineAttachmentCollectorContext;

public:
    TAutocodeFinePhotoCollectorContext(
        const NDrive::IServer& server,
        const TAttachmentConstructor& fineAttachmentConstructor,
        const TString& fineId,
        const TString& rulingNumber,
        TEventsHandler::TEventPtr relatedEventPtr
    );

    virtual size_t GetCollectedTotal() const override;

private:
    R_FIELD(TVector<NDrive::NAutocode::TAutocodeFinePhoto>, Photos);
};

class TRTAutocodeFinePhotoCollector: public TRTFineAttachmentCollectorBase {
    using TBase = TRTFineAttachmentCollectorBase;

    using TState = TRTAutocodeFinePhotoCollectorState;
    using TContext = TAutocodeFinePhotoCollectorContext;

public:
    TRTAutocodeFinePhotoCollector();

    virtual TString GetType() const override {
        return TypeName;
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    static const TString TypeName;

private:
    virtual NDrive::NFine::TFineFilterGroup GetFilters(const NDrive::IServer& server, const TFineIdToEventPtrMapping& fineIdToEventPtrMapping) const override;

    virtual TAtomicSharedPtr<IState> BuildState(const ui64 lastEventId) const override;
    virtual IBaseContext::TPtr ConstructContext(
        const NDrive::IServer& server,
        const NDrive::NFine::TFineAttachmentConstructor& fineAttachmentConstructor,
        const TString& fineId,
        const TString& rulingNumber,
        TEventsHandler::TEventPtr relatedEventPtr
    ) const override;

    virtual bool FilterFine(const IBaseContext::TPtr context, TMessagesCollector& errors) const override;

    virtual bool CollectExternalAttachments(IBaseContext::TPtr context, TMessagesCollector& errors) const override;
    virtual bool ConstructNativeFineAttachments(IBaseContext::TPtr context, TMessagesCollector& errors) const override;

private:
    static TFactory::TRegistrator<TRTAutocodeFinePhotoCollector> Registrator;

    R_READONLY(bool, ExplicitPhotoOnlyFlag, true);
    R_READONLY(bool, CameraFixationOnlyFlag, false);
};
