#pragma once

#include "processor_base.h"

#include <drive/library/cpp/autocode/constants.h>
#include <drive/library/cpp/autocode/entities.h>

class TAutocodeFinesProcessingContext : public IFineProcessingContextBase {
    using TBase = IFineProcessingContextBase;
    using TExternalFine = NDrive::NAutocode::TAutocodeFine;

public:
    TAutocodeFinesProcessingContext(const NDrive::IServer& server
        , const NDrive::NFine::TFineConstructor& fineConstructor
        , const TPrefechedFinesContainer& prefechedFines
        , TVector<TExternalFine>&& externalFines
    );

    bool OnBeforeCommit(const NDrive::NFine::TAutocodeFineEntry& fine);

private:
    R_FIELD(TVector<TExternalFine>, ExternalFines);

    R_FIELD(TVector<TString>, FineIdsToConfirm);
};

class TRTAutocodeFinesCollector: public TRTFinesCollectorBase {
    using TBase = TRTFinesCollectorBase;

    using TContext = TAutocodeFinesProcessingContext;

    using EPenaltyCheckPolicy = NDrive::NAutocode::EPenaltyCheckPolicy;
    using TAutocodeFine = NDrive::NAutocode::TAutocodeFine;

public:
    TRTAutocodeFinesCollector();

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return TypeName;
    }

    virtual NDrive::NFine::ESourceType GetSourceType() const override {
        return NDrive::NFine::ESourceType::Autocode;
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    static const TString TypeName;

private:
    bool IsRequestSizeUnlimited() const;
    bool CollectFines(const NDrive::IServer& server, ui64 offset, ui64 limit, TVector<TAutocodeFine>& fines) const;
    TVector<TAutocodeFine> FilterCollectedFines(TSet<TString>& collectedRulingNumbers, TVector<TAutocodeFine>&& fines) const;

    IFineProcessingContextBase::TPtr ConstructProcessingContext(const NDrive::IServer& server
        , const NDrive::NFine::TFineConstructor& fineConstructor
        , const TPrefechedFinesContainer& prefechedFines
        , TVector<TAutocodeFine>&& fines
    ) const;

    virtual bool ConstructFines(IFineProcessingContextBase::TPtr contextPtr, TVector<TAutocodeFineEntry>& nativeFines, TMessagesCollector& errors) const override;
    bool ProcessFine(const IFineProcessingContextBase::TPtr contextPtr, const TAutocodeFine& fine, TAutocodeFineEntry& nativeFine, TMessagesCollector& errors) const;

    virtual bool OnBeforeCommit(const IFineProcessingContextBase::TPtr contextPtr, const TVector<TAutocodeFineEntry>& fines, NDrive::TEntitySession& session, TMessagesCollector& errors) const override;
    virtual bool OnAfterCommit(const IFineProcessingContextBase::TPtr contextPtr, TMessagesCollector& errors) const override;

private:
    static TFactory::TRegistrator<TRTAutocodeFinesCollector> Registrator;

    static const ui32 DefaultMaxRequestFinesCount;

    R_FIELD(TInstant, MinRulingDate, TInstant::Zero());

    R_FIELD(TSet<TString>, StsToCheck);
    R_FIELD(bool, ExcludeSts, false);

    R_FIELD(ui32, MaxRequestFinesCount, DefaultMaxRequestFinesCount);  // refer to IsRequestSizeUnlimited method
    R_FIELD(EPenaltyCheckPolicy, PenaltyCheckPolicy, EPenaltyCheckPolicy::NotPaid);

    R_FIELD(bool, ConfirmCollectingStatus, true);
};
