#pragma once

#include "events.h"
#include "statuses.h"

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/common/state.h>

#include <drive/backend/fines/context_fetchers/fine_context.h>
#include <drive/backend/notifications/collection.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/library/unistat/cache.h>
#include <rtline/util/types/accessor.h>

// consider to generalize fine and tag interaction using common alert schemes
//   or merge with charge state handler at least

class TRTDismissedCarWatcherState : public TRTHistoryWatcherState {
private:
    static TFactory::TRegistrator<TRTDismissedCarWatcherState> Registrator;

public:
    static TString GetTypeName();

    virtual TString GetType() const override {
        return GetTypeName();
    }
};

class TRTDismissedCarWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    using TState = TRTDismissedCarWatcherState;

    using EHandlingStatus = NDrive::NFine::ECarDismissalHandlingStatus;

    using TNotifyHandlers = TContextNotifyHandlerCollection<EHandlingStatus, NDrive::NFine::IFineContextFetcher>;

public:
    TRTDismissedCarWatcher();

    static TString GetTypeName();

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

protected:
    virtual bool DoStart(const TRTBackgroundProcessContainer& container) override;
    virtual void InitNotifyHandlers() final;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TAtomicSharedPtr<TState> BuildState(const ui64 lastEventId) const;

    bool HandleHistoryEvents(const NDrive::IServer& server) const;
    EHandlingStatus HandleEvent(const NDrive::IServer& server, TAtomicSharedPtr<TCarTagHistoryEvent> ev, TMessagesCollector& errors) const;

    EHandlingStatus MarkCarDismissed(const NDrive::IServer& server, const TString& carId, TMessagesCollector& errors) const;

    bool InitTagEventsHandler(const TSet<TString>& tagNames);

private:
    static TFactory::TRegistrator<TRTDismissedCarWatcher> Registrator;

    R_READONLY(TSet<TString>, TagNames);
    R_READONLY(bool, RetryOnError, true);

    R_FIELD(TNotifyHandlers::TPtr, NotifyHandlers, nullptr);

    mutable TEventsHandler TagEventsHandler;
};
