#pragma once

#include <drive/backend/rt_background/common/config.h>

#include <drive/backend/background/manager/regular.h>
#include <drive/backend/cars/hardware.h>
#include <drive/backend/data/device_tags.h>

#include <drive/library/cpp/element/client.h>


class TRTElementCarWatcherProcess : public IRTCarsProcess {
private:
    using TLessorsMap = TMap<TString, NDrive::EDepartment>;
    using TBase = IRTCarsProcess;

private:
    R_READONLY(TString, NotifierName);
    R_READONLY(TLessorsMap, LessorsMap);
    R_READONLY(bool, DryRun, false);
    R_READONLY(bool, DeactivateAbsent, false);
    R_READONLY(TDuration, Timeout, TDuration::Minutes(1));

    static TFactory::TRegistrator<TRTElementCarWatcherProcess> Registrator;

protected:
    TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    NJson::TJsonValue DoSerializeToJson() const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "element_car_watcher";
    }
};
