#pragma once

#include "attachment_processor_base.h"

#include <drive/library/cpp/element/entities.h>


class TRTElementFinePhotoCollectorState : public IFineAttachmentCollectorState {
public:
    virtual TString GetType() const override;

private:
    static TFactory::TRegistrator<TRTElementFinePhotoCollectorState> Registrator;
};

class TElementFinePhotoCollectorContext : public IFineAttachmentCollectorContext {
    using TBase = IFineAttachmentCollectorContext;
public:
    using TBase::TBase;
    virtual size_t GetCollectedTotal() const override;

private:
    R_FIELD(TVector<NDrive::TElementFineAttachment>, Photos);
};

class TRTElementFinePhotoCollector: public TRTFineAttachmentCollectorBase {
    using TBase = TRTFineAttachmentCollectorBase;
    using TState = TRTElementFinePhotoCollectorState;
    using TContext = TElementFinePhotoCollectorContext;

    static TFactory::TRegistrator<TRTElementFinePhotoCollector> Registrator;
public:
    TRTElementFinePhotoCollector();

    virtual TString GetType() const override;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static const TString TypeName;

private:
    virtual NDrive::NFine::TFineFilterGroup GetFilters(const NDrive::IServer& server, const TFineIdToEventPtrMapping& fineIdToEventPtrMapping) const override;
    virtual TAtomicSharedPtr<IState> BuildState(const ui64 lastEventId) const override;
    virtual IBaseContext::TPtr ConstructContext(const NDrive::IServer& server, const NDrive::NFine::TFineAttachmentConstructor& fineAttachmentConstructor, const TString& fineId, const TString& rulingNumber, TEventsHandler::TEventPtr relatedEventPtr) const override;
    virtual bool FilterFine(const IBaseContext::TPtr context, TMessagesCollector& errors) const override;
    virtual bool CollectExternalAttachments(IBaseContext::TPtr context, TMessagesCollector& errors) const override;
    virtual bool ConstructNativeFineAttachments(IBaseContext::TPtr context, TMessagesCollector& errors) const override;
};
