#pragma once

#include "processor_base.h"

#include <drive/backend/rt_background/common/state.h>

#include <drive/library/cpp/element/entities.h>


class TRTElementFinesCollectorState : public TRTInstantWatcherState {
    static TFactory::TRegistrator<TRTElementFinesCollectorState> Registrator;
public:
    virtual TString GetType() const override;
};

class TElementFinesProcessingContext : public IFineProcessingContextBase {
    using TBase = IFineProcessingContextBase;

public:
    using TExternalFine = NDrive::TElementFine;
    using TRulingNumberMap = TMultiMap<TString, std::reference_wrapper<const NDrive::NFine::TAutocodeFineEntry>>;

public:
    TElementFinesProcessingContext(const NDrive::IServer& server
        , const NDrive::NFine::TFineConstructor& fineConstructor
        , const TPrefechedFinesContainer& prefechedFines
        , TVector<TExternalFine>&& externalFines
    );

private:
    R_FIELD(TVector<TExternalFine>, ExternalFines);
};

class TRTElementFinesCollector : public TRTFinesCollectorBase {
    using TBase = TRTFinesCollectorBase;
    using TContext = TElementFinesProcessingContext;
    using TContextPtr = TAtomicSharedPtr<TContext>;
    using TElementFine = NDrive::TElementFine;

public:
    enum class EPenaltyCheckPolicy {
        All,
        Paid,
        NotPaid
    };

public:
    TRTElementFinesCollector();

    virtual TString GetType() const override;
    virtual NDrive::NFine::ESourceType GetSourceType() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual bool ConstructFines(IFineProcessingContextBase::TPtr contextPtr, TVector<TAutocodeFineEntry>& nativeFines, TMessagesCollector& errors) const override;

public:
    static const TString TypeName;
    static const ui32 DefaultMaxRequestFinesCount;

private:
    bool ProcessFine(const TContextPtr contextPtr, const TElementFine& fine, TAutocodeFineEntry& nativeFine, TMessagesCollector& errors) const;
    TVector<TElementFine> FilterCollectedFines(TVector<TElementFine>&& fines) const;

private:
    static TFactory::TRegistrator<TRTElementFinesCollector> Registrator;

    R_FIELD(TInstant, MinRulingDate, TInstant::Zero());
    R_FIELD(TSet<TString>, StsToCheck);
    R_FIELD(bool, ExcludeSts, false);
    R_FIELD(ui32, MaxRequestFinesCount, DefaultMaxRequestFinesCount);  // refer to IsRequestSizeUnlimited method
    R_FIELD(EPenaltyCheckPolicy, PenaltyCheckPolicy, EPenaltyCheckPolicy::All);
    R_FIELD(bool, UpdateAllowedFlag, false);
    R_FIELD(bool, UpdateUnknownArticleOnly, false);
};
