#pragma once

#include "handler_base.h"

class TRTFineDocumentHandlerState : public TRTFinesHandlerBaseState {
public:
    virtual TString GetType() const override;

private:
    static TFactory::TRegistrator<TRTFineDocumentHandlerState> Registrator;
};

class TRTFineDocumentHandler: public TRTFinesHandlerBase {
private:
    using TBase = TRTFinesHandlerBase;
    static TFactory::TRegistrator<TRTFineDocumentHandler> Registrator;

    class TUpdateContext : public IUpdateContext {
        R_FIELD(TString, ViolationDetailedDocumentFileUrl);
    };

public:
    TRTFineDocumentHandler();

    virtual TString GetType() const override {
        return TypeName;
    }

    static const TString TypeName;

private:
    virtual TAtomicSharedPtr<TRTFinesHandlerBaseState> BuildState(const ui64 lastProcessedSerialId, const ui64 lastProcessedEventId) const override;
    virtual IUpdateContext::TPtr ConstructUpdateContext() const override;
    virtual EProcessingStatus PrepareUpdate(const NDrive::IServer& server, IUpdateContext::TPtr updateContextPtr, NDrive::NFine::TAutocodeFineEntry& fine, TFineIdToEventPtrMapping& fineIdToEventPtrMapping, TMessagesCollector& errors) const override;
    virtual EProcessingStatus ApplyUpdate(const NDrive::IServer& server, const IUpdateContext::TPtr updateContextPtr, NDrive::NFine::TAutocodeFineEntry& fine, NDrive::TEntitySession& session, TMessagesCollector& errors) const override;
};
