#pragma once

#include "handler_base.h"

#include <drive/backend/fines/constructors/tag_constructor.h>
#include <drive/backend/fines/restrictions/user.h>
#include <drive/backend/tags/tags.h>

class TRTFinesHandlerState : public TRTFinesHandlerBaseState {
public:
    virtual TString GetType() const override;

private:
    static TFactory::TRegistrator<TRTFinesHandlerState> Registrator;
};

class TRTFinesHandler: public TRTFinesHandlerBase {
private:
    using TBase = TRTFinesHandlerBase;
    static TFactory::TRegistrator<TRTFinesHandler> Registrator;

    class TUpdateContext : public IFinesHandlerUpdateContext{
        R_FIELD(TVector<ITag::TPtr>, TagPtrs);
    };

    R_FIELD(NDrive::NFine::TFineChargeTagConfig, ChargeTagConfig);
    R_FIELD(NDrive::NFine::TFineMailTagConfig, MailTagConfig);
    R_FIELD(NDrive::NFine::TFinePushTagConfig, PushTagConfig);
    R_FIELD(TVector<NDrive::NFine::IFineTagConfig::TPtr>, TagConfigs);

    R_FIELD(NFineUserRestrictions::TFineUserRestrictions, UserRestrictions);

public:
    TRTFinesHandler();

    virtual TString GetType() const override {
        return TypeName;
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    static const TString TypeName;

private:
    virtual TAtomicSharedPtr<TRTFinesHandlerBaseState> BuildState(const ui64 lastProcessedSerialId, const ui64 lastProcessedEventId) const override;

    virtual IUpdateContext::TPtr ConstructUpdateContext() const override;

    virtual EProcessingStatus CheckFineRestrictions(const NDrive::IServer& server, const NDrive::NFine::TAutocodeFineEntry& fine, NDrive::TEntitySession& session) const override;

    virtual EProcessingStatus PrepareUpdate(const NDrive::IServer& server, IUpdateContext::TPtr updateContextPtr, NDrive::NFine::TAutocodeFineEntry& fine, TFineIdToEventPtrMapping& fineIdToEventPtrMapping, TMessagesCollector& errors) const override;
    bool CreateTags(const NDrive::NFine::TFineFetchContext& context, TVector<ITag::TPtr>& tagPtrs, TMessagesCollector& errors) const;

    virtual EProcessingStatus ApplyUpdate(const NDrive::IServer& server, const IUpdateContext::TPtr updateContextPtr, NDrive::NFine::TAutocodeFineEntry& fine, NDrive::TEntitySession& session, TMessagesCollector& errors) const override;
    bool AddTags(const NDrive::IServer& server, const NDrive::NFine::TAutocodeFineEntry& fine, const TVector<ITag::TPtr>& tagPtrs, TVector<TDBTag>& affectedTags, NDrive::TEntitySession& session, TMessagesCollector& errors) const;
    bool UpsertFine(const NDrive::IServer& server, const TVector<TDBTag>& affectedTags, NDrive::NFine::TAutocodeFineEntry& fine, NDrive::TEntitySession& session, TMessagesCollector& errors) const;
};
