#pragma once

#include "attachment_processor_base.h"

#include <drive/backend/major/entities.h>

class TRTMajorFineDecreeCollectorState : public IFineAttachmentCollectorState {
public:
    static TString GetTypeName();

    virtual TString GetType() const override {
        return GetTypeName();
    }

private:
    static TFactory::TRegistrator<TRTMajorFineDecreeCollectorState> Registrator;
};

class TMajorFineDecreeCollectorContext : public IFineAttachmentCollectorContext {
    using TBase = IFineAttachmentCollectorContext;

public:
    TMajorFineDecreeCollectorContext(
        const NDrive::IServer& server,
        const TAttachmentConstructor& fineAttachmentConstructor,
        const TString& fineId,
        const TString& rulingNumber,
        TEventsHandler::TEventPtr relatedEventPtr
    );

    virtual size_t GetCollectedTotal() const override;

private:
    R_FIELD(NMajorClient::TCarPenaltyDecreeRequest::TCarPenaltyDecree, Decree);
};

class TRTMajorFineDecreeCollector: public TRTFineAttachmentCollectorBase {
    using TBase = TRTFineAttachmentCollectorBase;

    using TState = TRTMajorFineDecreeCollectorState;
    using TContext = TMajorFineDecreeCollectorContext;

public:
    TRTMajorFineDecreeCollector();

    virtual TString GetType() const override {
        return TypeName;
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    static const TString TypeName;

private:
    virtual NDrive::NFine::TFineFilterGroup GetFilters(const NDrive::IServer& server, const TFineIdToEventPtrMapping& fineIdToEventPtrMapping) const override;

    virtual TAtomicSharedPtr<IState> BuildState(const ui64 lastEventId) const override;
    virtual IBaseContext::TPtr ConstructContext(
        const NDrive::IServer& server,
        const NDrive::NFine::TFineAttachmentConstructor& fineAttachmentConstructor,
        const TString& fineId,
        const TString& rulingNumber,
        TEventsHandler::TEventPtr relatedEventPtr
    ) const override;

    virtual bool FilterFine(const IBaseContext::TPtr context, TMessagesCollector& errors) const override;

    virtual bool CollectExternalAttachments(IBaseContext::TPtr context, TMessagesCollector& errors) const override;
    virtual bool ConstructNativeFineAttachments(IBaseContext::TPtr context, TMessagesCollector& errors) const override;

private:
    static TFactory::TRegistrator<TRTMajorFineDecreeCollector> Registrator;

    R_FIELD(TSet<TString>, RulingNumbers);

    R_READONLY(bool, WithoutPhotoOnly, true);
    R_READONLY(bool, ExplicitDecreeOnlyFlag, true);
};
