#pragma once

#include <util/generic/serialized_enum.h>
#include <util/string/cast.h>

namespace NDrive::NFine {
    enum class ECollectingStatus {
        FetchExistingError /* "fetch_existing_error" */,

        CollectingTotal /* "collecting_total" */,
        CollectingFail /* "collecting_fail" */,
        CollectingSuccess /* "collecting_success" */,

        CollectedTotal /* "collected_total" */,
        CollectedFiltered /* "collected_filtered" */,
        CollectedMatched /* "collected_matched" */,
        CollectedNotMatched /* "collected_not_matched" */,

        CollectedConversionError /* "collected_conversion_error" */,
        CollectedInconsistentMetaInfo /* "collected_inconsistent_meta_info" */,

        CollectedBadArticle /* "collected_bad_article" */,
        CollectedUnrecognizedArticle /* "collected_unrecognized_article" */,
        CollectedMatchingSkipCount /* "collected_matching_skip_count" */,
        CollectedInvalidAmount /* "collected_invalid_amount" */,
        CollectedInvalidDiscount /* "collected_invalid_discount" */,
        CollectedManuallyPaidDuplicate /* "collected_manually_paid_duplicate" */,
        CollectedInappropriateCityParking /* "collected_inappropriate_city_parking" */,
        CollectedInappropriateLongTermParking /* "collected_inappropriate_long_term_parking" */,
        // CollectedNegativeAmount /* "collected_negative_amount" */,  // deprecated
        // CollectedFractionalAmount /* "collected_fractional_amount" */,  // deprecated

        TagUpsertError /* "tag_upsert_error" */,
        UpsertError /* "upsert_error" */,
        CommitError /* "commit_error" */,

        // major collector specific
        MaxCheckDelay /* "max_check_delay" */,
    };

    enum class EAttachmentCollectingStatus {
        CollectingFail /* "collecting_fail" */,
        CollectingSuccess /* "collecting_success" */,

        CollectedTotal /* "collected_total" */,

        CollectedConstructingError /* "collected_constructing-error" */,

        TagUpsertError /* "tag_upsert_error" */,
        UpsertError /* "upsert_error" */,
        CommitError /* "commit_error" */
    };

    enum class EProcessingStatus {
        FetchExistingError /* "fetch_existing_error" */,
        FetchFinesSuccess /* "fetch_fines_success" */,

        CalendarRestrictionsSkip /* "calendar_restrictions_skip" */,
        TimeIntervalLimitSkip /* "time_interval_limit_skip" */,

        /* CheckFineRestrictions statuses */
        WaitingForPhotoSkip /* "waiting_for_photo_skip" */,  // PhotoRestrictionsSkip can be used instead
        PhotoRestrictionsSkip /* "photo_restrictions_skip" */,
        DecreeRestrictionsSkip /* "decree_restrictions_skip" */,
        UserRestrictionsSkip /* "user_restrictions_skip" */,

        CheckFineSuccess /* "check_fine_success" */,

        /* PrepareUpdate statuses */
        ChargeStatusCheckError /* "charge_status_check_error" */,
        DataFetchingError /* "data_fetching_error" */,
        TagConstructingError /* "tag_constructing_error" */,

        DataFetchingSuccess /* "data_fetching_success" */,

        /* ApplyUpdate statuses */
        FineUpsertError /* "fine_upsert_error" */,
        TagUpsertError /* "tag_upsert_error" */,

        FineUpsertSuccess /* "fine_upsert_success" */,

        Success /* "success" */,
    };

    enum class EProcessingResult : i32 {
        OK = 0 /* "OK" */,
        SKIP = 1 /* "SKIP" */,

        STOP_REQUIRED = 10 /* "STOP_REQUIRED" */,  // used to compare only
        LIMIT_REACHED = 11 /* "LIMIT_REACHED" */,
        CRITICAL_ERROR = 12 /* "CRITICAL_ERROR" */,
    };

    using EFineProcessingResult = EProcessingResult;
    using EFineAttachmentProcessingResult = EProcessingResult;

    enum class EChargeStateHandlingStatus {
        /* HandleFines statuses */
        FetchFinesError /* "fetch_fines_error" */,
        // RestoreFineError /* "restore_fine_error" */,  // deprecated

        /* HandleEvent statuses */
        InvalidTagData /* "invalid_tag_data" */,
        AbsentRelatedFine /* "absent_related_fine" */,
        SkipFine /* "skip_fine" */,   // fine processing status, internal usage only

        /* MarkFineCharged statuses */
        AlreadyMarked /* "already_marked" */,
        UpsertError /* "upsert_error" */,
        MarkSuccessful /* "mark_successful" */,
    };

    enum class ECarDismissalHandlingStatus {
        Skip /* "skip" */,

        InvalidSettingValue /* "invalid_setting_value" */,
        AlreadyMarked /* "already_marked" */,
        UpsertError /* "upsert_error" */,
        MarkSuccessful /* "mark_successful" */,
    };
}
