LIBRARY()

OWNER(
    g:drive-backend
    svshevtsov
)

SRCS(
    handler_base.cpp
    GLOBAL fines_handler.cpp
    GLOBAL fine_documents_handler.cpp
    attachment_processor_base.cpp
    GLOBAL autocode_photo_processor.cpp
    GLOBAL element_photo_processor.cpp
    GLOBAL major_decree_processor.cpp
    processor_base.cpp
    GLOBAL autocode_processor.cpp
    GLOBAL major_processor.cpp
    GLOBAL element_car_watcher.cpp
    GLOBAL element_processor.cpp
    GLOBAL charge_state_handler.cpp
    GLOBAL dismissed_car_watcher.cpp
    events.cpp
    statuses.cpp
)

PEERDIR(
    drive/backend/abstract
    drive/backend/abstract
    drive/backend/data
    drive/backend/database
    drive/backend/fines
    drive/backend/fines/constructors
    drive/backend/fines/context_fetchers
    drive/backend/fines/restrictions
    drive/backend/major
    drive/backend/notifications
    drive/backend/proto
    drive/backend/rt_background/manager
    drive/backend/tags
    drive/library/cpp/autocode
    drive/library/cpp/element
    library/cpp/cache
    library/cpp/regex/pcre
    library/cpp/threading/future
    rtline/library/json
    rtline/library/unistat
    rtline/util
    rtline/util/algorithm
    rtline/util/types
)

GENERATE_ENUM_SERIALIZATION(statuses.h)
GENERATE_ENUM_SERIALIZATION(element_processor.h)

END()
