#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/fueling_manager/fueling_manager.h>

class TUserFuelingTagCleanProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TUserFuelingTagCleanProcess> Registrator;
    R_FIELD(TSet<EFuelingStatus>, StatusesToRemove);

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "user_fueling_tag_cleaner";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
