#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/tags/tags_filter.h>

#include <drive/library/cpp/scheme/scheme.h>

class TRTFuturesBook: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
private:
    static TFactory::TRegistrator<TRTFuturesBook> Registrator;
    R_FIELD(TString, NotifierName);
public:
    virtual TString GetType() const override {
        return "futures_book";
    }

    using TBase::TBase;

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override {
        NJson::TJsonValue result = TBase::DoSerializeToJson();
        result.InsertValue("NotifierName", NotifierName);
        return result;
    }
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override {
        if (!TBase::DoDeserializeFromJson(jsonInfo)) {
            return false;
        }
        JREAD_STRING_OPT(jsonInfo, "NotifierName", NotifierName);
        return true;
    }
};
