#include "base.h"

const TString IMessageProvider::DefaultTypeName = "default";

IMessageProvider::TPtr IMessageProvider::Construct(
    const TString& templateName,
    const NJson::TJsonValue& config,
    const NDrive::IServer* server,
    const TString& processName,
    const TString& robotUserId,
    TInstant startInstant,
    NEntityTagsManager::EEntityType entityType
) {
    IMessageProvider::TPtr providerPtr = TFactory::Construct(templateName, IMessageProvider::DefaultTypeName);
    if (providerPtr && !providerPtr->InitContext(server, processName, startInstant, entityType, config)) {
        return nullptr;
    }
    if (providerPtr) {
        providerPtr->RobotUserId = robotUserId;
    }
    return providerPtr;
}

TSet<TString> IMessageProvider::GetRegisteredProviders() {
    TSet<TString> registeredProviders;
    TFactory::GetRegisteredKeys(registeredProviders);
    return registeredProviders;
}

NDrive::TScheme IMessageProvider::GetProvidersScheme(const NDrive::IServer* server) {
    NDrive::TScheme scheme;
    auto& providersScheme = scheme.Add<TFSVariable>("message_provider", "Провайдер сообщений");
    for (auto&& name: GetRegisteredProviders()) {
        if (IMessageProviderConfig::TFactory::Has(name)) {
            IMessageProviderConfig::TPtr providerConfigPtr = IMessageProviderConfig::TFactory::Construct(name);
            providersScheme.AddVariant(name, providerConfigPtr->GetScheme(server));
        } else {
            providersScheme.AddVariant(name);
        }
    }
    // providersScheme.MutableCondition().SetDefault(DefaultTypeName);  // scheme is processed incorrectly DRIVEFRONT-793
    return scheme;
}

bool IMessageProvider::HandleResult(TNotifierResultPtr /* resultPtr */, TMessagesCollector& /* errors */) const {
    return true;
}

bool IMessageProvider::InitContext(const NDrive::IServer* server, const TString& processName, const TInstant& startInstant, NEntityTagsManager::EEntityType entityType, const NJson::TJsonValue& /* config */) {
    Server = server;
    ProcessName = processName;
    StartInstant = startInstant;
    EntityType = entityType;
    return true;
}
