#pragma once

#include "base.h"

class TImagesSnapshotConfig: public IMessageProviderConfig {
    using TBase = IMessageProviderConfig;

public:
    using TBase::TBase;

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    NJson::TJsonValue SerializeToJson() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) override;

private:
    using TRegistrator = TFactory::TRegistrator<TImagesSnapshotConfig>;
    static TRegistrator Registrator;
};

class TImagesSnapshotMessageProvider: public IMessageProvider {
    using TBase = IMessageProvider;
    using TConfig = TImagesSnapshotConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

    virtual TMessages Fetch(const TCarTagHistoryEvent& event, TMessagesCollector& errors) const override;

private:
    virtual bool InitContext(const NDrive::IServer* server, const TString& processName, const TInstant& startInstant, NEntityTagsManager::EEntityType entityType, const NJson::TJsonValue& config) override;

private:
    using TRegistrator = TFactory::TRegistrator<TImagesSnapshotMessageProvider>;
    static TRegistrator Registrator;

    R_READONLY(TAtomicSharedPtr<TConfig>, Config);
};
