#include "st_default.h"

#include "constants.h"

#include <drive/backend/data/billing_tags.h>
#include <drive/backend/data/device_tags.h>
#include <drive/backend/tags/history.h>

#include <util/string/split.h>

TStartrekDefaultMessageProvider::TRegistrator TStartrekDefaultMessageProvider::Registrator;
TStartrekDefaultConfig::TRegistrator TStartrekDefaultConfig::Registrator(TStartrekDefaultMessageProvider::GetTypeName());

TString TStartrekDefaultMessageProvider::GetTypeName() {
    return "st_default";
}

TString TStartrekDefaultMessageProvider::GetType() const {
    return GetTypeName();
}

TAtomicSharedPtr<TStartrekBaseMessageConfig> TStartrekDefaultMessageProvider::ConstructConfig(const NJson::TJsonValue& data) const {
    return TConfig::Construct<TConfig>(data);
}

TStartrekDefaultMessageProvider::TMessages TStartrekDefaultMessageProvider::DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const {
    auto message = MakeAtomicShared<TStartrekMessage>(issue);
    SetMessageTransitId(event, message);

    if (!!GetConfig()->GetSummaryTemplate()) {
        TStartrekTicket ticket;
        if (!DoFetchTicketDescription(event, ticket, errors)) {
            AddSignal(::ToString(EFetcherSignal::InvalidCreateTicketMessage));
            return {};
        }
        message->SetUpdate(ticket);
        AddSignal(::ToString(EFetcherSignal::CreateTicketMessage));
    } else {
        TString comment;
        if (!DoFetchAddTagComment(event, comment, errors)) {
            AddSignal(::ToString(EFetcherSignal::InvalidTicketCommentMessage));
            return {};
        }
        message->SetComment(comment);
        AddSignal(::ToString(EFetcherSignal::TicketCommentMessage));
    }
    return {message};
}

TStartrekDefaultMessageProvider::TMessages TStartrekDefaultMessageProvider::DoFetchRemoveTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const {
    auto message = MakeAtomicShared<TStartrekMessage>(issue);
    SetMessageTransitId(event, message);
    TString comment;
    if (!DoFetchRemoveTagComment(event, comment, errors)) {
        AddSignal(::ToString(EFetcherSignal::InvalidTicketCommentMessage));
        return {};
    }
    message->SetComment(comment);
    AddSignal(::ToString(EFetcherSignal::TicketCommentMessage));
    return {message};
}
