#pragma once

#include "st_base.h"

#include <drive/backend/notifications/startrek/startrek.h>

#include <drive/library/cpp/scheme/scheme.h>
#include <drive/library/cpp/startrek/client.h>

#include <library/cpp/object_factory/object_factory.h>

#include <rtline/util/json_processing.h>

#include <util/datetime/base.h>
#include <util/generic/vector.h>

class TStartrekDefaultConfig: public TStartrekBaseMessageConfig {
    using TBase = TStartrekBaseMessageConfig;

public:
    using TBase::TBase;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekDefaultConfig>;
    static TRegistrator Registrator;
};

class TStartrekDefaultMessageProvider: public IStartrekBaseMessageProvider {
    using TBase = IStartrekBaseMessageProvider;
    using TConfig = TStartrekDefaultConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

private:
    virtual TAtomicSharedPtr<TStartrekBaseMessageConfig> ConstructConfig(const NJson::TJsonValue& data) const override;

    virtual TMessages DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;
    virtual TMessages DoFetchRemoveTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekDefaultMessageProvider>;
    static TRegistrator Registrator;
};
