#pragma once

#include "st_base.h"

#include <drive/backend/notifications/startrek/startrek.h>

#include <drive/library/cpp/scheme/scheme.h>
#include <drive/library/cpp/startrek/client.h>

#include <library/cpp/object_factory/object_factory.h>

#include <util/datetime/base.h>
#include <util/generic/set.h>

class TDriveEvacuationConfig: public TStartrekBaseMessageConfig {
    using TBase = TStartrekBaseMessageConfig;

public:
    enum class ETicketField {
        CarNumber /* "stateNumber" */,  // string
        EvacuationDate /* "evacuationDate" */,  // iso formatted timestamp
        ViolationPlace /* "violationPlace" */,  // string
        AmountPaid /* "amountPaidByClient" */,  // double
    };

    static const TVector<TString> Queues;
    static const TDuration DefaultTransactionTimeout;

    TDriveEvacuationConfig()
        : TBase(Queues)
    {
    }

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) override;

private:
    using TRegistrator = TFactory::TRegistrator<TDriveEvacuationConfig>;
    static TRegistrator Registrator;

    R_READONLY(TSet<TString>, AddTagTransitions, {});
    R_READONLY(TSet<TString>, RemoveTagTransitions, {});
    R_READONLY(TSet<TString>, LongTransactionTags, {});
    R_READONLY(TDuration, TransactionTimeout, DefaultTransactionTimeout);
};

class TDriveEvacuationMessageProvider: public IStartrekBaseMessageProvider {
    using TBase = IStartrekBaseMessageProvider;
    using TConfig = TDriveEvacuationConfig;

public:
    using TTransitions = TStartrekClient::TTransitions;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

private:
    virtual TAtomicSharedPtr<TStartrekBaseMessageConfig> ConstructConfig(const NJson::TJsonValue& data) const override;

    virtual TMessages DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;
    virtual TMessages DoFetchRemoveTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TDriveEvacuationMessageProvider>;
    static TRegistrator DriveEvacuationRegistrator;
};
