#include "st_drive_repair.h"

#include "constants.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/tags/history.h>
#include <drive/backend/tags/tags_manager.h>

TDriveRepairMessageProvider::TRegistrator TDriveRepairMessageProvider::DriveRepairRegistrator;
TDriveRepairConfig::TRegistrator TDriveRepairConfig::Registrator(TDriveRepairMessageProvider::GetTypeName());

const TVector<TString> TDriveRepairConfig::Queues = {"DRIVEREPAIR"};

TDriveRepairConfig::TDriveRepairConfig()
    : TBase(Queues)
{
    SetProtectedLinkIssueOnTagAdd(true);
}

TString TDriveRepairMessageProvider::GetTypeName() {
    return "st_drive_repair";
}

TString TDriveRepairMessageProvider::GetType() const {
    return GetTypeName();
}

TAtomicSharedPtr<TStartrekBaseMessageConfig> TDriveRepairMessageProvider::ConstructConfig(const NJson::TJsonValue& data) const {
    return TConfig::Construct<TConfig>(data);
}

TDriveRepairMessageProvider::TMessages TDriveRepairMessageProvider::DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const {
    auto message = MakeAtomicShared<TStartrekMessage>(issue);
    SetMessageTransitId(event, message);

    TStartrekTicket ticket;
    if (!DoFetchTicketDescription(event, ticket, errors)) {
        AddSignal(::ToString(EFetcherSignal::InvalidTicketUpdateMessage));
        return {};
    }
    message->SetUpdate(ticket);

    AddSignal(::ToString(EFetcherSignal::TicketUpdateMessage));
    return {message};
}
