#pragma once

#include "st_base.h"

#include <drive/backend/notifications/startrek/startrek.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <library/cpp/object_factory/object_factory.h>

#include <rtline/util/json_processing.h>

class TDriveRepairConfig: public TStartrekBaseMessageConfig {
    using TBase = TStartrekBaseMessageConfig;

public:
    static const TVector<TString> Queues;

    TDriveRepairConfig();

private:
    using TRegistrator = TFactory::TRegistrator<TDriveRepairConfig>;
    static TRegistrator Registrator;
};

class TDriveRepairMessageProvider: public IStartrekBaseMessageProvider {
    using TBase = IStartrekBaseMessageProvider;
    using TConfig = TDriveRepairConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

private:
    virtual TAtomicSharedPtr<TStartrekBaseMessageConfig> ConstructConfig(const NJson::TJsonValue& data) const override;

    virtual TMessages DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TDriveRepairMessageProvider>;
    static TRegistrator DriveRepairRegistrator;
};
