#pragma once

#include "st_base.h"

#include <drive/backend/notifications/startrek/startrek.h>

#include <drive/library/cpp/scheme/scheme.h>
#include <drive/library/cpp/startrek/client.h>

#include <library/cpp/object_factory/object_factory.h>

#include <util/generic/map.h>
#include <util/generic/vector.h>

class TDriveSecurityConfig: public TStartrekBaseMessageConfig {
    using TBase = TStartrekBaseMessageConfig;

public:
    enum class ETicketField {
        Deadline /* "deadline" */,  // iso formatted timestamp
        TotalToPay /* "amountToPayByClient" */,  // double
        TotalPaid /* "amountPaidByClient" */,  // double
    };

    static const TVector<TString> Queues;

    TDriveSecurityConfig()
        : TBase(Queues)
    {
    }

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    NJson::TJsonValue SerializeToJson() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) override;

private:
    using TRegistrator = TFactory::TRegistrator<TDriveSecurityConfig>;
    static TRegistrator Registrator;

    R_READONLY(TVector<TString>, SuccessfulPaymentSummonees, {});
};

class TDriveSecurityMessageProvider: public IStartrekBaseMessageProvider {
    using TBase = IStartrekBaseMessageProvider;
    using TConfig = TDriveSecurityConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

private:
    virtual TAtomicSharedPtr<TStartrekBaseMessageConfig> ConstructConfig(const NJson::TJsonValue& data) const override;

    virtual TMessages DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;
    virtual TMessages DoFetchRemoveTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;
    virtual TMessages DoFetchUpdateData(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TDriveSecurityMessageProvider>;
    static TRegistrator DriveSecurityRegistrator;
};
