#include "st_drive_security_awaiting_info.h"

#include "constants.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/tags/history.h>
#include <drive/backend/tags/tags_manager.h>

#include <rtline/library/json/adapters.h>
#include <rtline/library/json/cast.h>
#include <rtline/util/json_processing.h>

TStartrekDriveSecurityAwaitingInfoMessageProvider::TRegistrator TStartrekDriveSecurityAwaitingInfoMessageProvider::Registrator;
TStartrekDriveSecurityAwaitingInfoConfig::TRegistrator TStartrekDriveSecurityAwaitingInfoConfig::Registrator(TStartrekDriveSecurityAwaitingInfoMessageProvider::GetTypeName());

NDrive::TScheme TStartrekDriveSecurityAwaitingInfoConfig::GetScheme(const NDrive::IServer* server) const {
    auto scheme = TBase::GetScheme(server);
    scheme.Add<TFSArray>("add_event_tags", "Проставить ticket tags при добавлении тега").SetElement<TFSString>();
    scheme.Add<TFSString>("await_info_timestamp_field", "Имя поля времени добавления тега").SetRequired(true);
    return scheme;
}

NJson::TJsonValue TStartrekDriveSecurityAwaitingInfoConfig::SerializeToJson() const {
    NJson::TJsonValue result = TBase::SerializeToJson();
    NJson::InsertField(result, "add_event_tags", AddEventTags);
    NJson::InsertField(result, "await_info_timestamp_field", AwaitInfoTimestampField);
    return result;
}

bool TStartrekDriveSecurityAwaitingInfoConfig::DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) {
    return NJson::ParseField(config["add_event_tags"], AddEventTags) &&
           (NJson::ParseField(config["await_info_timestamp_field"], AwaitInfoTimestampField, true) && AwaitInfoTimestampField) &&
           TBase::DeserializeFromJson(config, errors);
}

TString TStartrekDriveSecurityAwaitingInfoMessageProvider::GetTypeName() {
    return "st_drive_security_awaiting_info";
}

TString TStartrekDriveSecurityAwaitingInfoMessageProvider::GetType() const {
    return GetTypeName();
}

TAtomicSharedPtr<TStartrekBaseMessageConfig> TStartrekDriveSecurityAwaitingInfoMessageProvider::ConstructConfig(const NJson::TJsonValue& data) const {
    return TConfig::Construct<TConfig>(data);
}

TStartrekDriveSecurityAwaitingInfoMessageProvider::TMessages TStartrekDriveSecurityAwaitingInfoMessageProvider::DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& /* errors */) const {
    auto message = MakeAtomicShared<TStartrekMessage>(issue);
    SetMessageTransitId(event, message);

    auto config = GetConfig()->GetAsSafe<TConfig>();

    TStartrekTicket ticket;

    if (config.GetAddEventTags()) {
        ticket.AddAdditionalContainerValue(::ToString(TStartrekTicket::EContainerTicketField::Tags), config.GetAddEventTags());
    }

    auto awaitInfoTimestamp = event.GetHistoryTimestamp();
    ticket.SetAdditionalValue(config.GetAwaitInfoTimestampField(), NJson::ToJson(NJson::IsoFormat(awaitInfoTimestamp.Get())));

    message->SetUpdate(ticket);

    AddSignal(::ToString(EFetcherSignal::TicketUpdateMessage));

    return {message};
}
