#pragma once

#include "st_base.h"

#include <drive/backend/notifications/startrek/startrek.h>

#include <drive/library/cpp/scheme/scheme.h>
#include <drive/library/cpp/startrek/client.h>
#include <drive/library/cpp/startrek/entity.h>

#include <library/cpp/object_factory/object_factory.h>

#include <util/generic/map.h>
#include <util/generic/vector.h>

class TStartrekDriveSecurityAwaitingInfoConfig: public TStartrekBaseMessageConfig {
    using TBase = TStartrekBaseMessageConfig;

public:
    using TBase::TBase;

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    NJson::TJsonValue SerializeToJson() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) override;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekDriveSecurityAwaitingInfoConfig>;
    static TRegistrator Registrator;

    R_FIELD(TSet<TString>, AddEventTags);
    R_FIELD(TString, AwaitInfoTimestampField);
};

class TStartrekDriveSecurityAwaitingInfoMessageProvider: public IStartrekBaseMessageProvider {
    using TBase = IStartrekBaseMessageProvider;
    using TConfig = TStartrekDriveSecurityAwaitingInfoConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

private:
    virtual TAtomicSharedPtr<TStartrekBaseMessageConfig> ConstructConfig(const NJson::TJsonValue& data) const override;

    virtual TMessages DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekDriveSecurityAwaitingInfoMessageProvider>;
    static TRegistrator Registrator;
};
