#pragma once

#include "st_base.h"

#include <drive/backend/notifications/startrek/startrek.h>

#include <drive/library/cpp/scheme/scheme.h>
#include <drive/library/cpp/startrek/client.h>
#include <drive/library/cpp/startrek/entity.h>

#include <library/cpp/object_factory/object_factory.h>

#include <util/generic/map.h>
#include <util/generic/vector.h>

// note: this provider is a generalization of exisiting ones and it's going to replace them
//   moreover a simplification is planned soon (dated 2020-02-21)

class TStartrekDriveTechGenericMessageConfig: public TStartrekBaseMessageConfig {
    using TBase = TStartrekBaseMessageConfig;

public:
    TStartrekDriveTechGenericMessageConfig();

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    NJson::TJsonValue SerializeToJson() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) override;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekDriveTechGenericMessageConfig>;
    static TRegistrator Registrator;

    R_READONLY(TString, AdditionalAttributesTemplate);
    R_READONLY(TString, CommentTemplate);
    R_READONLY(TString, RemoveTagUpdateTemplate);
};

class TStartrekDriveTechGenericMessageProvider: public IStartrekBaseMessageProvider {
    using TBase = IStartrekBaseMessageProvider;
    using TConfig = TStartrekDriveTechGenericMessageConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

private:
    virtual TAtomicSharedPtr<TStartrekBaseMessageConfig> ConstructConfig(const NJson::TJsonValue& data) const override;

    virtual TMessages DoFetchAddTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;
    virtual TMessages DoFetchRemoveTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;
    virtual TMessages DoFetchEvolveTag(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;

    bool NeedToCreateIssueOnAction(const EObjectHistoryAction action) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekDriveTechGenericMessageProvider>;
    static TRegistrator StartrekDriveTechGenericRegistrator;
};
