#pragma once

#include "st_base.h"

class TStartrekUploadAttachmentsConfig: public TStartrekBaseMessageConfig {
    using TBase = TStartrekBaseMessageConfig;

public:
    static const TString DefaultBucketName;
    static const TString DefaultCommentTemplate;
    static const TString DefaultUploadErrorCommentTemplate;

    using TBase::TBase;

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    NJson::TJsonValue SerializeToJson() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) override;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekUploadAttachmentsConfig>;
    static TRegistrator Registrator;

    R_FIELD(TString, BucketName, DefaultBucketName);
    R_FIELD(TString, CommentTemplate, DefaultCommentTemplate);
    R_FIELD(TString, UploadErrorCommentTemplate, DefaultUploadErrorCommentTemplate);
};

class TStartrekUploadAttachmentsMessageProvider: public IStartrekBaseMessageProvider {
    using TBase = IStartrekBaseMessageProvider;
    using TConfig = TStartrekUploadAttachmentsConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

private:
    virtual TAtomicSharedPtr<TStartrekBaseMessageConfig> ConstructConfig(const NJson::TJsonValue& data) const override;

    virtual TMessages DoFetchAddSnapshot(const TCarTagHistoryEvent& event, const TString& issue, TMessagesCollector& errors) const override;

private:
    using TRegistrator = TFactory::TRegistrator<TStartrekUploadAttachmentsMessageProvider>;
    static TRegistrator Registrator;
};
