#pragma once

#include "base.h"

#include <library/cpp/regex/pcre/regexp.h>

class TUserInfoConfig: public IMessageProviderConfig {
    using TBase = IMessageProviderConfig;

public:
    using TBase::TBase;

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    NJson::TJsonValue SerializeToJson() const override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& config, TMessagesCollector& errors) override;

private:
    using TRegistrator = TFactory::TRegistrator<TUserInfoConfig>;
    static TRegistrator Registrator;

    R_READONLY(NDrive::TLocationAreaIds, AreaIds);
    R_READONLY(TSet<TString>, DeviceIds);
    R_READONLY(TString, UserAgentPattern);
    R_OPTIONAL(ui32, MaxSessionsCount);
    R_READONLY(bool, FreshAccounts, false);
};

class TUserInfoMessageProvider: public IMessageProvider {
    using TBase = IMessageProvider;
    using TConfig = TUserInfoConfig;

public:
    static TString GetTypeName();
    virtual TString GetType() const override;

    virtual TMessages Fetch(const TCarTagHistoryEvent& event, TMessagesCollector& errors) const override;

private:
    virtual bool InitContext(const NDrive::IServer* server, const TString& processName, const TInstant& startInstant, NEntityTagsManager::EEntityType entityType, const NJson::TJsonValue& config) override;

private:
    using TRegistrator = TFactory::TRegistrator<TUserInfoMessageProvider>;
    static TRegistrator Registrator;

    R_READONLY(TAtomicSharedPtr<TConfig>, Config);

    R_OPTIONAL(TRegExMatch, UserAgentRegEx);
};
