#pragma once

#include <drive/backend/database/history/event.h>
#include <drive/backend/rt_background/common/database.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TRTHistoryReplicatorState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTHistoryReplicatorState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTHistoryReplicator: public TDBTableScanner {
    R_FIELD(TString, DestinationDBName);
    R_FIELD(TString, DestinationHistoryTableName);
    R_FIELD(TString, SourceEntityTableName);
    R_FIELD(TString, DestinationEntityTableName);
    R_FIELD(TString, EntityIdColumn);
    R_FIELD(TString, HistoryActionColumnName, "history_action");
    R_FIELD(TSet<EObjectHistoryAction>, RemoveHistoryActions);

private:
    using TBase = TDBTableScanner;
    static TFactory::TRegistrator<TRTHistoryReplicator> Registrator;
public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "history_replicator";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    virtual bool ProcessRecords(const TRecordsSet& records, const NDrive::IServer& server, ui64& lastEventId, TMessagesCollector& errors) const override;
    virtual TRTHistoryWatcherState* BuildState() const override {
        return new TRTHistoryReplicatorState();
    }
};
