#pragma once

#include "statuses.h"

#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/notifications/collection.h>

#include <rtline/util/types/accessor.h>

class TRTReninsClaimCatalogueUpdater: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

    using EStatus = NDrive::EReninsClaimCatalogueUpdateStatus;

    using TNotifyHandlers = TNotifyHandlerCollection<EStatus>;

public:
    TRTReninsClaimCatalogueUpdater();

    static TString GetTypeName();

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

protected:
    virtual bool DoStart(const TRTBackgroundProcessContainer& container) override;
    virtual void InitNotifyHandlers() final;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

private:
    static TFactory::TRegistrator<TRTReninsClaimCatalogueUpdater> Registrator;

    R_FIELD(TNotifyHandlers::TPtr, NotifyHandlers, nullptr);
};
