#pragma once

#include <drive/backend/rt_background/manager/settings.h>

class IRTBackgroundProcessState;

namespace NDrivematics {
    class TIssueDateThresholdChecker : public IRTRegularBackgroundProcess {
    private:
        using TBase = IRTRegularBackgroundProcess;

    public:
        static TString GetTypeName();

    private:
        virtual TString GetType() const override;
        virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
        virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    private:
        ui32 IssueDateThreshold;
        static TFactory::TRegistrator<TIssueDateThresholdChecker> Registrator;
    };
}
