#pragma once

#include <drive/backend/data/long_term.h>
#include <drive/backend/data/notifications_tags.h>
#include <drive/backend/rt_background/common/config.h>

class TLongTermBeforeDeliveryProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual bool DoCheckRunCondition(const NDrive::IServer& server, const TOfferHolderTag& offerHolderTag, NDrive::TEntitySession& tx) const = 0;
    virtual bool DoRun(const NDrive::IServer& server, const TDBTag& offerHolder, NDrive::TEntitySession& tx) const;
    virtual TOptionalDBTags GetOfferHolders(const NDrive::IServer& server, NDrive::TEntitySession& tx) const;
    virtual void FillNotificationTag(ITag::TPtr tag, const TOfferHolderTag& offerHolderTag, const ILocalization* localization) const;
    virtual TInstant GetScheduledAt(const TOfferHolderTag& offerHolderTag) const;

protected:
    TDuration NotificationInterval = TDuration::Days(1);
    TSet<TString> TagNames;
    TString NotificationTagName;
};
