#include "helper.h"

#include <drive/backend/billing/manager.h>

ui32 GetFirstPayment(const TLongTermOffer& longTermOffer) {
    auto quanta = longTermOffer.GetOrBuildPaymentSchedule().GetQuanta();
    Y_ENSURE(!quanta.empty());
    return longTermOffer.GetPublicDiscountedPrice(quanta.begin()->Value);
}

bool FirstPaymentDone(const NDrive::IServer& server, const TOfferHolderTag& offerHolderTag, NDrive::TEntitySession& tx) {
    auto longTermOffer = Yensured(std::dynamic_pointer_cast<TLongTermOffer>(offerHolderTag.GetOffer()));

    TCachedPayments payments;
    Y_ENSURE(server.GetDriveAPI()->GetBillingManager().GetPaymentsManager().GetPayments(payments, longTermOffer->GetOfferId(), tx));
    return payments.GetFailedPayMethods().empty() || payments.GetHeldSum() >= GetFirstPayment(*longTermOffer);
}
