#include "no_money_cancel_process.h"

#include "helper.h"

bool TLongTermNoMoneyCancelProcess::DoCheckRunCondition(const NDrive::IServer& server, const TOfferHolderTag& offerHolderTag, NDrive::TEntitySession& tx) const {
    return !FirstPaymentDone(server, offerHolderTag, tx);
}

bool TLongTermNoMoneyCancelProcess::DoRun(const NDrive::IServer& server, const TDBTag& longTermOfferHolderTag, NDrive::TEntitySession& tx) const {
    if (!TBase::DoRun(server, longTermOfferHolderTag, tx)) {
        return false;
    }
    Y_ENSURE(server.GetDriveAPI()->GetTagsManager().GetUserTags().RemoveTag(longTermOfferHolderTag, GetRobotUserId(), &server, tx, true), tx.GetStringReport());
    return true;
}

TLongTermNoMoneyCancelProcess::TFactory::TRegistrator<TLongTermNoMoneyCancelProcess> TLongTermNoMoneyCancelProcess::Registrator(TLongTermNoMoneyCancelProcess::GetTypeName());
