#include "not_assigned_cancel_process.h"

#include "helper.h"


bool TLongTermNotAssignedCancelProcess::DoCheckRunCondition(const NDrive::IServer& server, const TOfferHolderTag& offerHolderTag, NDrive::TEntitySession& tx) const {
    Y_UNUSED(server);
    Y_UNUSED(tx);
    auto longTermOffer = Yensured(std::dynamic_pointer_cast<TLongTermOffer>(offerHolderTag.GetOffer()));
    return !longTermOffer->GetObjectId();
}

bool TLongTermNotAssignedCancelProcess::DoRun(const NDrive::IServer& server, const TDBTag& longTermOfferHolderTag, NDrive::TEntitySession& tx) const {
    if (!TBase::DoRun(server, longTermOfferHolderTag, tx)) {
        return false;
    }
    Y_ENSURE(server.GetDriveAPI()->GetTagsManager().GetUserTags().RemoveTag(longTermOfferHolderTag, GetRobotUserId(), &server, tx, true), tx.GetStringReport());
    return true;
}

TLongTermNotAssignedCancelProcess::TFactory::TRegistrator<TLongTermNotAssignedCancelProcess> TLongTermNotAssignedCancelProcess::Registrator(TLongTermNotAssignedCancelProcess::GetTypeName());
