#pragma once

#include <drive/backend/rt_background/common/config.h>

class TLongTermAutoassignProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "long_term_autoassign";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TSet<TString> OfferNames;
    TString TargetTagName;
    TDuration AssignmentInterval = TDuration::Days(1);
    bool DryRun = false;

private:
    static TFactory::TRegistrator<TLongTermAutoassignProcess> Registrator;
};

class TLongTermPaymentPushProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "long_term_payment_push";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TSet<TString> OfferNames;
    TString UserTagName;
    TDuration WarningInterval = TDuration::Days(3);
    ui32 WarningMileage = 1000;

private:
    static TFactory::TRegistrator<TLongTermPaymentPushProcess> Registrator;
};
