#pragma once

#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/abstract/frontend.h>

class TDBTag;

class TRTUserMailSenderProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    R_FIELD(TString, Notifier);
    R_FIELD(ui32, PackSize, 1000);
    static TFactory::TRegistrator<TRTUserMailSenderProcess> Registrator;

public:
    using TBase::TBase;
    TString GetType() const override;
    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    NJson::TJsonValue DoSerializeToJson() const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual TExpectedState DoExecute(
        TAtomicSharedPtr<IRTBackgroundProcessState> state,
        const TExecutionContext& context) const override;

private:
    void RemoveTagsGently(const NDrive::IServer* server,
                          const TVector<TDBTag>& tagsForRemove) const;
};
